<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStoreLocationsOpeningTable extends Migration {

	public function up()
	{
		Schema::create('store_locations_opening', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->time('opening_at');
			$table->time('closing_at');
			$table->enum('weekday', array('1', '2', '3', '4', '5', '6', '7'));
			$table->bigInteger('store_location_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('store_locations_opening');
	}
}