<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Attachment extends Eloquent {

	protected $table = 'attachments';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('attachment_type_id', 'path');

	public function form()
	{
		return $this->belongsTo('App\Models\Form');
	}

	public function type()
	{
		return $this->belongsTo('App\Models\AttachmentType');
	}

}