<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAdvertisementsTable extends Migration {

	public function up()
	{
		Schema::create('advertisements', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->unsigned();
			$table->integer('code');
			$table->enum('status', array('new', 'published', 'blocked', 'rejected', 'archived'));
			$table->string('name');
			$table->string('description');
			$table->bigInteger('sub_category_id')->unsigned();
			$table->boolean('is_electronic');
			$table->string('url')->nullable();
			$table->string('notes')->nullable();
			$table->decimal('price');
			$table->decimal('partenership_ratio');
			$table->decimal('profit');
			$table->decimal('avg_sales_year');
			$table->decimal('avg_profit_year');
			$table->enum('type', array('exist', 'under_constraction'));
			$table->enum('age', array('less_than_one_year', '1-2years', '3-5years', 'morethan5years'));
			$table->boolean('has_regulation');
			$table->boolean('has_future_work');
			$table->bigInteger('city_id')->unsigned();
			$table->string('address');
			$table->string('lat');
			$table->string('long');
			$table->string('mobile');
			$table->string('whatsapp');
			$table->string('inactive_reason')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('advertisements');
	}
}