<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Invoice extends Model 
{

    protected $table = 'invoice';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('customer_name', 'phone', 'date', 'country', 'city', 'container_number', 'note');

    public function invoice_items()
    {
        return $this->hasMany('InvoiceItem', 'invoice_id');
    }

}