<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePostsTable extends Migration {

	public function up()
	{
		Schema::create('posts', function(Blueprint $table) {
			$table->increments('id');
			$table->enum('type', array('post', 'invoice', 'wish_list'));
			$table->bigInteger('purchse_id')->nullable();
			$table->enum('attachment_type', array('text', 'image', 'video', 'file', 'record', 'invoice', 'image_text', 'video_text', 'file_text', 'record_text', 'invoice_text', 'map'));
			$table->enum('wash_list_type', array('midea', 'map', 'product'))->nullable();
			$table->morphs('author');
			$table->longText('caption')->nullable();
			$table->bigInteger('likes_count');
			$table->bigInteger('views_count')->default('1');
			$table->string('link')->nullable();
			$table->nullableMorphs('mentionable')->default('App\Models\User');
			$table->bigInteger('ratings_count')->default('0');
			$table->decimal('ratings_avg')->default('0');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('comments_count');
		});
	}

	public function down()
	{
		Schema::drop('posts');
	}
}