<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVerificationCodesTable extends Migration {

	public function up()
	{
		Schema::create('verification_codes', function(Blueprint $table) {
			$table->increments('id');
			$table->string('user_type', 50)->default('App\Models\User');
			$table->string('country_code', 5);
			$table->string('phone', 50);
			$table->enum('type', array('activation', 'reset_password', 'update_phone'));
			$table->boolean('is_verified')->default(0);
			$table->timestamp('code_expire');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('verification_codes');
	}
}