<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('groups', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('contact_groups', function(Blueprint $table) {
			$table->foreign('contact_id')->references('id')->on('contacts')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('contact_groups', function(Blueprint $table) {
			$table->foreign('group_id')->references('id')->on('groups')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('post_target_groups', function(Blueprint $table) {
			$table->foreign('post_id')->references('id')->on('posts')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('post_target_groups', function(Blueprint $table) {
			$table->foreign('group_id')->references('user_id')->on('groups')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('post_target_group_exclusions', function(Blueprint $table) {
			$table->foreign('post_id')->references('id')->on('posts')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('post_target_group_exclusions', function(Blueprint $table) {
			$table->foreign('group_id')->references('user_id')->on('groups')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('post_target_group_exclusions', function(Blueprint $table) {
			$table->foreign('contact_id')->references('id')->on('contacts')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('comments')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('wishlist_categories', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('wishlist_category_groups', function(Blueprint $table) {
			$table->foreign('wishlist_category_id')->references('id')->on('wishlist_categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('wishlist_category_groups', function(Blueprint $table) {
			$table->foreign('group_id')->references('id')->on('groups')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('category_store', function(Blueprint $table) {
			$table->foreign('store_id')->references('id')->on('stores')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('category_store', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('store_info', function(Blueprint $table) {
			$table->foreign('provider_id')->references('id')->on('stores')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('store_socials', function(Blueprint $table) {
			$table->foreign('communication_id')->references('id')->on('communications')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('store_socials', function(Blueprint $table) {
			$table->foreign('store_id')->references('id')->on('stores')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('store_images', function(Blueprint $table) {
			$table->foreign('store_id')->references('id')->on('stores')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('favorite_stores', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('favorite_stores', function(Blueprint $table) {
			$table->foreign('store_id')->references('id')->on('stores')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('post_ratings', function(Blueprint $table) {
			$table->foreign('post_id')->references('id')->on('posts')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('point_histories', function(Blueprint $table) {
			$table->foreign('point_id')->references('id')->on('points')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('groups', function(Blueprint $table) {
			$table->dropForeign('groups_user_id_foreign');
		});
		Schema::table('contact_groups', function(Blueprint $table) {
			$table->dropForeign('contact_groups_contact_id_foreign');
		});
		Schema::table('contact_groups', function(Blueprint $table) {
			$table->dropForeign('contact_groups_group_id_foreign');
		});
		Schema::table('post_target_groups', function(Blueprint $table) {
			$table->dropForeign('post_target_groups_post_id_foreign');
		});
		Schema::table('post_target_groups', function(Blueprint $table) {
			$table->dropForeign('post_target_groups_group_id_foreign');
		});
		Schema::table('post_target_group_exclusions', function(Blueprint $table) {
			$table->dropForeign('post_target_group_exclusions_post_id_foreign');
		});
		Schema::table('post_target_group_exclusions', function(Blueprint $table) {
			$table->dropForeign('post_target_group_exclusions_group_id_foreign');
		});
		Schema::table('post_target_group_exclusions', function(Blueprint $table) {
			$table->dropForeign('post_target_group_exclusions_contact_id_foreign');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->dropForeign('comments_parent_id_foreign');
		});
		Schema::table('wishlist_categories', function(Blueprint $table) {
			$table->dropForeign('wishlist_categories_user_id_foreign');
		});
		Schema::table('wishlist_category_groups', function(Blueprint $table) {
			$table->dropForeign('wishlist_category_groups_wishlist_category_id_foreign');
		});
		Schema::table('wishlist_category_groups', function(Blueprint $table) {
			$table->dropForeign('wishlist_category_groups_group_id_foreign');
		});
		Schema::table('category_store', function(Blueprint $table) {
			$table->dropForeign('category_store_store_id_foreign');
		});
		Schema::table('category_store', function(Blueprint $table) {
			$table->dropForeign('category_store_category_id_foreign');
		});
		Schema::table('store_info', function(Blueprint $table) {
			$table->dropForeign('store_info_provider_id_foreign');
		});
		Schema::table('store_socials', function(Blueprint $table) {
			$table->dropForeign('store_socials_communication_id_foreign');
		});
		Schema::table('store_socials', function(Blueprint $table) {
			$table->dropForeign('store_socials_store_id_foreign');
		});
		Schema::table('store_images', function(Blueprint $table) {
			$table->dropForeign('store_images_store_id_foreign');
		});
		Schema::table('favorite_stores', function(Blueprint $table) {
			$table->dropForeign('favorite_stores_user_id_foreign');
		});
		Schema::table('favorite_stores', function(Blueprint $table) {
			$table->dropForeign('favorite_stores_store_id_foreign');
		});
		Schema::table('post_ratings', function(Blueprint $table) {
			$table->dropForeign('post_ratings_post_id_foreign');
		});
		Schema::table('point_histories', function(Blueprint $table) {
			$table->dropForeign('point_histories_point_id_foreign');
		});
	}
}