<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSlidesTable extends Migration {

	public function up()
	{
		Schema::create('slides', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('image');
			$table->string('heading')->nullable();
			$table->text('description');
			$table->string('link');
			$table->boolean('status')->default(0);
		});
	}

	public function down()
	{
		Schema::drop('slides');
	}
}