<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('plates', function(Blueprint $table) {
			$table->foreign('restaurant_id')->references('id')->on('restaurants')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('categories', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('categories')
						->onDelete('restrict')
						->onUpdate('no action');
		});
		Schema::table('categories', function(Blueprint $table) {
			$table->foreign('restaurant_id')->references('id')->on('restaurants')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('restaurant_id')->references('id')->on('restaurants')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('tables', function(Blueprint $table) {
			$table->foreign('restaurant_id')->references('id')->on('restaurants')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('order_plates', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('order_plates', function(Blueprint $table) {
			$table->foreign('plate_id')->references('id')->on('plates')
						->onDelete('restrict')
						->onUpdate('no action');
		});
		Schema::table('ingredients', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('removable_ingredients', function(Blueprint $table) {
			$table->foreign('plate_id')->references('id')->on('plates')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('plate_ingredients', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('plate_ingredients', function(Blueprint $table) {
			$table->foreign('plate_id')->references('id')->on('plates')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('plate_ingredients', function(Blueprint $table) {
			$table->foreign('ingredient_id')->references('id')->on('ingredients')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('plate_removable_ingredients', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('plate_removable_ingredients', function(Blueprint $table) {
			$table->foreign('removable_ingredient_id')->references('id')->on('removable_ingredients')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('restaurant_id')->references('id')->on('restaurants')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('cards', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('cascade')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('plates', function(Blueprint $table) {
			$table->dropForeign('plates_restaurant_id_foreign');
		});
		Schema::table('categories', function(Blueprint $table) {
			$table->dropForeign('categories_parent_id_foreign');
		});
		Schema::table('categories', function(Blueprint $table) {
			$table->dropForeign('categories_restaurant_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_restaurant_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_client_id_foreign');
		});
		Schema::table('tables', function(Blueprint $table) {
			$table->dropForeign('tables_restaurant_id_foreign');
		});
		Schema::table('order_plates', function(Blueprint $table) {
			$table->dropForeign('order_plates_order_id_foreign');
		});
		Schema::table('order_plates', function(Blueprint $table) {
			$table->dropForeign('order_plates_plate_id_foreign');
		});
		Schema::table('ingredients', function(Blueprint $table) {
			$table->dropForeign('ingredients_category_id_foreign');
		});
		Schema::table('removable_ingredients', function(Blueprint $table) {
			$table->dropForeign('removable_ingredients_plate_id_foreign');
		});
		Schema::table('plate_ingredients', function(Blueprint $table) {
			$table->dropForeign('plate_ingredients_order_id_foreign');
		});
		Schema::table('plate_ingredients', function(Blueprint $table) {
			$table->dropForeign('plate_ingredients_plate_id_foreign');
		});
		Schema::table('plate_ingredients', function(Blueprint $table) {
			$table->dropForeign('plate_ingredients_ingredient_id_foreign');
		});
		Schema::table('plate_removable_ingredients', function(Blueprint $table) {
			$table->dropForeign('plate_removable_ingredients_order_id_foreign');
		});
		Schema::table('plate_removable_ingredients', function(Blueprint $table) {
			$table->dropForeign('plate_removable_ingredients_removable_ingredient_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_restaurant_id_foreign');
		});
		Schema::table('cards', function(Blueprint $table) {
			$table->dropForeign('cards_client_id_foreign');
		});
	}
}