<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->text('products');
			$table->integer('user_id');
			$table->integer('cart_id')->unsigned();
			$table->string('gift')->nullable();
			$table->text('gift_message')->nullable();
			$table->decimal('products_total');
			$table->decimal('discount');
			$table->decimal('shipping_cost');
			$table->decimal('total_paid');
			$table->date('delivery_date');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}