<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('vacante', function(Blueprint $table) {
			$table->foreign('id_cargo')->references('id')->on('cargo')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('vacante', function(Blueprint $table) {
			$table->foreign('id_tipoContratacion')->references('id')->on('tipoContratacion')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('cargo', function(Blueprint $table) {
			$table->foreign('id_departamento')->references('id')->on('departamento')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('habilidadRequerida', function(Blueprint $table) {
			$table->foreign('id_habilidad')->references('id')->on('habilidad')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('habilidadRequerida', function(Blueprint $table) {
			$table->foreign('id_vacante')->references('id')->on('vacante')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('vacante_postulado', function(Blueprint $table) {
			$table->foreign('id_vacante')->references('id')->on('vacante')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('vacante_postulado', function(Blueprint $table) {
			$table->foreign('id_postulante')->references('id')->on('postulante')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('evaluacion', function(Blueprint $table) {
			$table->foreign('id_tipoEvaluacion')->references('id')->on('tipoEvaluacion')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('evaluacion', function(Blueprint $table) {
			$table->foreign('id_especialistaRRHH')->references('id')->on('especialistaRRHH')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tipoEvaluacion', function(Blueprint $table) {
			$table->foreign('id_tipoCalificacion')->references('id')->on('tipoCalificacion')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('especialistaRRHH', function(Blueprint $table) {
			$table->foreign('id_trabajador')->references('id')->on('trabajador')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('especialistaRRHH', function(Blueprint $table) {
			$table->foreign('id_evaluacion')->references('id')->on('evaluacion')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('trabajador', function(Blueprint $table) {
			$table->foreign('id_cargo')->references('id')->on('cargo')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('evaluacionPorPostulante', function(Blueprint $table) {
			$table->foreign('id_postulante')->references('id')->on('postulante')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('evaluacionPorPostulante', function(Blueprint $table) {
			$table->foreign('id_evaluacion')->references('id')->on('evaluacion')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('vacante', function(Blueprint $table) {
			$table->dropForeign('vacante_id_cargo_foreign');
		});
		Schema::table('vacante', function(Blueprint $table) {
			$table->dropForeign('vacante_id_tipoContratacion_foreign');
		});
		Schema::table('cargo', function(Blueprint $table) {
			$table->dropForeign('cargo_id_departamento_foreign');
		});
		Schema::table('habilidadRequerida', function(Blueprint $table) {
			$table->dropForeign('habilidadRequerida_id_habilidad_foreign');
		});
		Schema::table('habilidadRequerida', function(Blueprint $table) {
			$table->dropForeign('habilidadRequerida_id_vacante_foreign');
		});
		Schema::table('vacante_postulado', function(Blueprint $table) {
			$table->dropForeign('vacante_postulado_id_vacante_foreign');
		});
		Schema::table('vacante_postulado', function(Blueprint $table) {
			$table->dropForeign('vacante_postulado_id_postulante_foreign');
		});
		Schema::table('evaluacion', function(Blueprint $table) {
			$table->dropForeign('evaluacion_id_tipoEvaluacion_foreign');
		});
		Schema::table('evaluacion', function(Blueprint $table) {
			$table->dropForeign('evaluacion_id_especialistaRRHH_foreign');
		});
		Schema::table('tipoEvaluacion', function(Blueprint $table) {
			$table->dropForeign('tipoEvaluacion_id_tipoCalificacion_foreign');
		});
		Schema::table('especialistaRRHH', function(Blueprint $table) {
			$table->dropForeign('especialistaRRHH_id_trabajador_foreign');
		});
		Schema::table('especialistaRRHH', function(Blueprint $table) {
			$table->dropForeign('especialistaRRHH_id_evaluacion_foreign');
		});
		Schema::table('trabajador', function(Blueprint $table) {
			$table->dropForeign('trabajador_id_cargo_foreign');
		});
		Schema::table('evaluacionPorPostulante', function(Blueprint $table) {
			$table->dropForeign('evaluacionPorPostulante_id_postulante_foreign');
		});
		Schema::table('evaluacionPorPostulante', function(Blueprint $table) {
			$table->dropForeign('evaluacionPorPostulante_id_evaluacion_foreign');
		});
	}
}