<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AccAssetEntryItem extends Model 
{

    protected $table = 'acc_asset_entry_item';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'fixed_asset_id', 'intangible_asset_id', 'division_id', 'place_id', 'division_place_id', 'amount', 'depreciation_entry_id', 'amortization_entry_id');

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function fixed_asset()
    {
        return $this->belongsTo('AccFixedAsset', 'fixed_asset_id');
    }

    public function division()
    {
        return $this->belongsTo('AccDivision', 'division_id');
    }

    public function place()
    {
        return $this->belongsTo('AccPlace', 'place_id');
    }

    public function division_place()
    {
        return $this->belongsTo('AccDivisionPlace', 'division_place_id');
    }

    public function depreciation_entry()
    {
        return $this->belongsTo('AccAssetEntry', 'depreciation_entry_id');
    }

    public function amortization_entry()
    {
        return $this->belongsTo('AccAssetEntry', 'amortization_entry_id');
    }

    public function intangible_asset()
    {
        return $this->belongsTo('AccIntangibleAsset', 'intangible_asset_id');
    }

}