<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AccCurrencyExchange extends Model 
{

    protected $table = 'acc_currency_exchange';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('date', 'currency_id', 'rate', 'transaction', 'user_id');

    public function currency()
    {
        return $this->belongsTo('AccCurrency', 'currency_id');
    }

    public function transactions()
    {
        return $this->hasMany('AccCurrencyExchangeTransaction', 'currency_exchange_id');
    }

}