<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AccEmployee extends Model 
{

    protected $table = 'acc_employee';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'employee_id', 'currency_id', 'division_id', 'division_place_id', 'place_id', 'control_account_id', 'address', 'starting_balance_type', 'starting_balance', 'status');

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function employee()
    {
        return $this->belongsTo('Employee', 'employee_id');
    }

    public function currency()
    {
        return $this->belongsTo('AccCurrency', 'currency_id');
    }

    public function division()
    {
        return $this->belongsTo('AccDivision', 'division_id');
    }

    public function division_place()
    {
        return $this->belongsTo('AccDivisionPlace', 'division_place_id');
    }

    public function place()
    {
        return $this->belongsTo('AccPlace', 'place_id');
    }

    public function control_account()
    {
        return $this->belongsTo('AccControlAccount', 'control_account_id');
    }

}