<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AccFixedAsset extends Model 
{

    protected $table = 'acc_fixed_asset';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('code', 'name_en', 'name_ar', 'depreciation_rate', 'description', 'user_id', 'division_id', 'place_id', 'division_place_id', 'control_account_cost_id', 'control_account_depreciation_id', 'acquisition_cost', 'acccumulated_depreciation', 'profit_loss_account_id', 'date_disposal', 'disposal_account_id', 'status', 'book_value', 'depreciation');

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function division()
    {
        return $this->belongsTo('AccDivision', 'division_id');
    }

    public function place()
    {
        return $this->belongsTo('AccPlace', 'place_id');
    }

    public function division_place()
    {
        return $this->belongsTo('AccDivisionPlace', 'division_place_id');
    }

    public function control_account_cost()
    {
        return $this->belongsTo('AccControlAccount', 'control_account_cost_id');
    }

    public function control_acount_depreciation()
    {
        return $this->belongsTo('AccControlAccount', 'control_acount_depreciation_id');
    }

    public function profit_loss_account()
    {
        return $this->belongsTo('AccProfitLossAccount', 'profit_loss_account_id');
    }

    public function disposal_account()
    {
        return $this->belongsTo('AccProfitLossAccount', 'disposal_account_id');
    }

    public function entries()
    {
        return $this->belongsToMany('AccAssetEntry', 'fixed_asset_id', 'asset_entry_id', 'asset_entry_item_id');
    }

}