<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AccInventoryItemAmount extends Model 
{

    protected $table = 'acc_inventory_item_amount';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('inventory_item_id', 'quantity', 'inventory_id', 'description', 'user_id');

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function inventory()
    {
        return $this->belongsTo('AccInventory', 'inventory_id');
    }

    public function inventory_item()
    {
        return $this->belongsTo('AccInventoryItem', 'inventory_item_id');
    }

}