<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AccInventoryTransfer extends Model 
{

    protected $table = 'acc_inventory_transfer';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('date', 'reference', 'from_inventory_id', 'to_inventory_id', 'description', 'total', 'quantity', 'user_id');

    public function inventory_items()
    {
        return $this->belongsToMany('AccInventoryItem', 'inventory_transfer_id', 'inventory_item_id', 'item_store_id');
    }

    public function item_stores()
    {
        return $this->hasMany('AccItemStore', 'inventory_transfer_id');
    }

    public function from_inventory()
    {
        return $this->belongsTo('AccInventory', 'from_inventory_id');
    }

    public function to_inventory()
    {
        return $this->belongsTo('AccInventory', 'to_inventory_id');
    }

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

}