<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AccItemStore extends Model 
{

    protected $table = 'acc_item_store';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('inventory_item_id', 'quantity', 'inventory_id', 'inventory_transfer_id', 'inventory_write_off_id', 'production_order_id', 'user_id', 'average_cost', 'description', 'inventory_kit_id');

    public function inventory_item()
    {
        return $this->belongsTo('AccInventoryItem', 'inventory_item_id');
    }

    public function inventory()
    {
        return $this->belongsTo('AccInventory', 'inventory_id');
    }

    public function inventory_transfer()
    {
        return $this->belongsTo('AccInventoryTransfer', 'inventory_transfer_id');
    }

    public function inventory_write_off()
    {
        return $this->belongsTo('AccInventoryWriteOff', 'inventory_write_off_id');
    }

    public function production_order()
    {
        return $this->belongsTo('AccProductionOrder', 'production_order_id');
    }

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

}