<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AccJournalEntry extends Model 
{

    protected $table = 'acc_journal_entry';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('date', 'reference', 'currency_id', 'description', 'cash_transaction', 'user_id', 'footer_id', 'status', 'accounts', 'debit', 'credit');

    public function footer()
    {
        return $this->belongsTo('AccFooter', 'footer_id');
    }

    public function currency()
    {
        return $this->belongsTo('AccCurrency', 'currency_id');
    }

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function items()
    {
        return $this->hasMany('AccItem', 'journal_entry_id');
    }

}