<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AccPayslip extends Model 
{

    protected $table = 'acc_payslip';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'employee_id', 'acc_employee_id', 'footer_id', 'date', 'description', 'refrence', 'show_total', 'title', 'from_date', 'gross_pay', 'deduction', 'net_pay', 'contribution');

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function employee()
    {
        return $this->belongsTo('Employee', 'employee_id');
    }

    public function acc_employee()
    {
        return $this->belongsTo('AccEmployee', 'acc_employee_id');
    }

    public function footer()
    {
        return $this->belongsTo('AccFooter', 'footer_id');
    }

    public function earnings()
    {
        return $this->hasMany('AccPayslipEarning', 'payslip_id');
    }

    public function deductions()
    {
        return $this->hasMany('AccPayslipDeduction', 'payslip_id');
    }

    public function contribution()
    {
        return $this->hasMany('AccPayslipContribution', 'payslip_id');
    }

}