<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AccProductionOrder extends Model 
{

    protected $table = 'acc_production_order';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('date', 'reference', 'description', 'inventory_id', 'finished_item_id', 'quantity', 'status', 'production_cost', 'total', 'user_id');

    public function inventory()
    {
        return $this->belongsTo('AccInventory', 'inventory_id');
    }

    public function finished_item()
    {
        return $this->belongsTo('AccInventoryItem', 'finished_item_id');
    }

    public function item_stores()
    {
        return $this->hasMany('AccItemStore', 'production_order_id');
    }

    public function accounts()
    {
        return $this->hasMany('AccProductionCost', 'production_order_id');
    }

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

}