<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AccProject extends Model 
{

    protected $table = 'acc_project';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'income', 'direct_cost', 'profit', 'status', 'user_id', 'code');

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

}