<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AccRecurringTransaction extends Model 
{

    protected $table = 'acc_recurring_transaction';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('date', 'interval_duration', 'interval_type', 'description', 'total', 'show_total', 'title', 'until_type', 'until_date', 'amount', 'user_id', 'footer_id', 'category_id', 'employee_id', 'paid_from_bank_account_id', 'received_in_bank_account_id', 'currency_id', 'customer_id', 'supplier_id', 'paid_by_type', 'other_name', 'due_date', 'billing_address', 'from_date');

    public function items()
    {
        return $this->hasMany('AccItem', 'recurring_transaction_id');
    }

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function footer()
    {
        return $this->belongsTo('AccFooter', 'footer_id');
    }

    public function category()
    {
        return $this->belongsTo('AccRecurringCategory', 'category_id');
    }

    public function employee()
    {
        return $this->belongsTo('Employee', 'employee_id');
    }

    public function paid_from_bank_account()
    {
        return $this->belongsTo('AccBankAccount', 'paid_from_bank_account_id');
    }

    public function received_in_bank_account()
    {
        return $this->belongsTo('AccBankAccount', 'received_in_bank_account_id');
    }

    public function currency()
    {
        return $this->belongsTo('AccCurrency', 'currency_id');
    }

    public function customer()
    {
        return $this->belongsTo('AccCustomer', 'customer_id');
    }

    public function supplier()
    {
        return $this->belongsTo('AccSupplier', 'supplier_id');
    }

    public function earnings()
    {
        return $this->hasMany('AccPayslipEarning', 'recurring_transaction_id');
    }

    public function deductions()
    {
        return $this->hasMany('AccPayslipDeduction', 'recurring_transaction_id');
    }

    public function contributions()
    {
        return $this->hasMany('AccPayslipContribution', 'recurring_transaction_id');
    }

}