<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateArpa3stepsLangTable extends Migration {

	public function up()
	{
		Schema::create('arpa3steps_lang', function(Blueprint $table) {
			$table->increments('id', true)->primary();
			$table->integer('arpa3steps_id');
			$table->integer('id_lang')->unique();
			$table->string('private_name', 255);
			$table->string('public_name', 255);
			$table->string('invoice_name');
			$table->text('tooltip_options_group')->nullable();
			$table->text('comp_options_group')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('arpa3steps_lang');
	}
}