<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAnswersTable extends Migration {

	public function up()
	{
		Schema::create('Answers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('answerable_id')->unsigned();
			$table->string('answerable_type');
			$table->integer('question_option_id')->unsigned();
			$table->integer('answer_numeric');
			$table->text('answer_text');
			$table->tinyInteger('answer_bool');
			$table->date('answer_date');
		});
	}

	public function down()
	{
		Schema::drop('Answers');
	}
}