<?php

namespace App\Models;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	public function country()
	{
		return $this->hasOne('Country', 'id', 'country_id');
	}

	public function city()
	{
		return $this->hasOne('City', 'id', 'city_id');
	}

	public function userFilter()
	{
		return $this->hasOne('UserFilter', 'user_id');
	}

	public function userType()
	{
		return $this->hasOne('UserType', 'id', 'user_type_id');
	}

	public function subscription()
	{
		return $this->hasOne('Subscription');
	}

	public function showInterests()
	{
		return $this->hasMany('ShowInterest', 'to_user_id');
	}

	public function chatRequest()
	{
		return $this->hasMany('ChatRequest', 'to_user_id');
	}

	public function blockList()
	{
		return $this->hasMany('BlockList', 'to_user_id');
	}

	public function userViewCount()
	{
		return $this->hasMany('UserViewCount', 'to');
	}

	public function abuseReport()
	{
		return $this->hasMany('AbuseReport', 'to_user_id');
	}

	public function userNotification()
	{
		return $this->hasMany('UserNotification');
	}

	public function privateFilter()
	{
		return $this->hasMany('PrivateFilter');
	}

	public function payment()
	{
		return $this->hasMany('Payment');
	}

}