<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('Agregat_Filiale', function(Blueprint $table) {
			$table->foreign('filiale_id')->references('id')->on('Filiales')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Agregat_Filiale', function(Blueprint $table) {
			$table->foreign('agregat_id')->references('id')->on('Agregats')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Categorie_eff_Filiale', function(Blueprint $table) {
			$table->foreign('filiale_id')->references('id')->on('Filiales')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Categorie_eff_Filiale', function(Blueprint $table) {
			$table->foreign('categorie_eff_id')->references('id')->on('Categories_eff')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Produits', function(Blueprint $table) {
			$table->foreign('unite_mesure')->references('id')->on('Unites_mesure')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Filiale_Produit', function(Blueprint $table) {
			$table->foreign('filiale_id')->references('id')->on('Filiales')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Filiale_Produit', function(Blueprint $table) {
			$table->foreign('produit_id')->references('id')->on('Produits')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Previsions', function(Blueprint $table) {
			$table->foreign('filiale_id')->references('id')->on('Filiales')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Realisations', function(Blueprint $table) {
			$table->foreign('filiale_id')->references('id')->on('Filiales')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Contrats', function(Blueprint $table) {
			$table->foreign('filiale_id')->references('id')->on('Filiales')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Contrats', function(Blueprint $table) {
			$table->foreign('fournisseur_id')->references('id')->on('Fournisseurs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Users', function(Blueprint $table) {
			$table->foreign('filiale_id')->references('id')->on('Filiales')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Users', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('Roles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Users_Rapports', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('Users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Users_Rapports', function(Blueprint $table) {
			$table->foreign('rapport_id')->references('id')->on('Rapports')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Formations', function(Blueprint $table) {
			$table->foreign('filiale_id')->references('id')->on('Filiales')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Formations', function(Blueprint $table) {
			$table->foreign('organisme_id')->references('id')->on('OrganismesFormation')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Sinistres_arrives', function(Blueprint $table) {
			$table->foreign('sinistre_id')->references('id')->on('Sinistres')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Sinistres_arrives', function(Blueprint $table) {
			$table->foreign('filiale_id')->references('id')->on('Filiales')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Sinistres_regles', function(Blueprint $table) {
			$table->foreign('filiale_id')->references('id')->on('Filiales')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Sinistres_regles', function(Blueprint $table) {
			$table->foreign('sinistre_id')->references('id')->on('Sinistres')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('Agregat_Filiale', function(Blueprint $table) {
			$table->dropForeign('Agregat_Filiale_filiale_id_foreign');
		});
		Schema::table('Agregat_Filiale', function(Blueprint $table) {
			$table->dropForeign('Agregat_Filiale_agregat_id_foreign');
		});
		Schema::table('Categorie_eff_Filiale', function(Blueprint $table) {
			$table->dropForeign('Categorie_eff_Filiale_filiale_id_foreign');
		});
		Schema::table('Categorie_eff_Filiale', function(Blueprint $table) {
			$table->dropForeign('Categorie_eff_Filiale_categorie_eff_id_foreign');
		});
		Schema::table('Produits', function(Blueprint $table) {
			$table->dropForeign('Produits_unite_mesure_foreign');
		});
		Schema::table('Filiale_Produit', function(Blueprint $table) {
			$table->dropForeign('Filiale_Produit_filiale_id_foreign');
		});
		Schema::table('Filiale_Produit', function(Blueprint $table) {
			$table->dropForeign('Filiale_Produit_produit_id_foreign');
		});
		Schema::table('Previsions', function(Blueprint $table) {
			$table->dropForeign('Previsions_filiale_id_foreign');
		});
		Schema::table('Realisations', function(Blueprint $table) {
			$table->dropForeign('Realisations_filiale_id_foreign');
		});
		Schema::table('Contrats', function(Blueprint $table) {
			$table->dropForeign('Contrats_filiale_id_foreign');
		});
		Schema::table('Contrats', function(Blueprint $table) {
			$table->dropForeign('Contrats_fournisseur_id_foreign');
		});
		Schema::table('Users', function(Blueprint $table) {
			$table->dropForeign('Users_filiale_id_foreign');
		});
		Schema::table('Users', function(Blueprint $table) {
			$table->dropForeign('Users_role_id_foreign');
		});
		Schema::table('Users_Rapports', function(Blueprint $table) {
			$table->dropForeign('Users_Rapports_user_id_foreign');
		});
		Schema::table('Users_Rapports', function(Blueprint $table) {
			$table->dropForeign('Users_Rapports_rapport_id_foreign');
		});
		Schema::table('Formations', function(Blueprint $table) {
			$table->dropForeign('Formations_filiale_id_foreign');
		});
		Schema::table('Formations', function(Blueprint $table) {
			$table->dropForeign('Formations_organisme_id_foreign');
		});
		Schema::table('Sinistres_arrives', function(Blueprint $table) {
			$table->dropForeign('Sinistres_arrives_sinistre_id_foreign');
		});
		Schema::table('Sinistres_arrives', function(Blueprint $table) {
			$table->dropForeign('Sinistres_arrives_filiale_id_foreign');
		});
		Schema::table('Sinistres_regles', function(Blueprint $table) {
			$table->dropForeign('Sinistres_regles_filiale_id_foreign');
		});
		Schema::table('Sinistres_regles', function(Blueprint $table) {
			$table->dropForeign('Sinistres_regles_sinistre_id_foreign');
		});
	}
}