<?php

class Filiale extends Eloquent {

	protected $table = 'Filiales';
	public $timestamps = true;

	public function agregat()
	{
		return $this->belongsToMany('Agregat')->withPivot(Agregat_Filiale);
	}

	public function categorieEff()
	{
		return $this->belongsToMany('CategorieEff')->withPivot(Categorie_eff_Filiale);
	}

	public function produit()
	{
		return $this->belongsToMany('Produit')->withPivot(Filiale_Produit);
	}

	public function prevision()
	{
		return $this->hasMany('Prevision', 'prevision_id');
	}

	public function realisatio()
	{
		return $this->hasMany('Realisation', 'realisation_id');
	}

	public function fournisseur()
	{
		return $this->belongsToMany('Fournisseur')->withPivot(Contrats);
	}

	public function organisme_formation()
	{
		return $this->belongsToMany('OrganismeFormation')->withPivot('Formations');
	}

}