<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class FlightPrice extends Model 
{

    protected $table = 'flight_prices';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('seat_id', 'flight_type_id', 'age_id', 'price', 'duration_id', 'flight_id');

    public function seat()
    {
        return $this->belongsTo('FlightSeat', 'seat_id');
    }

    public function flight_type()
    {
        return $this->belongsTo('FlightType', 'flight_type_id');
    }

    public function age()
    {
        return $this->belongsTo('Age', 'age_id');
    }

    public function flight()
    {
        return $this->belongsTo('Flight', 'flight_id');
    }

    public function duration()
    {
        return $this->belongsTo('Duration', 'duration_id');
    }

}