<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class FlightsClasses extends Model 
{

    protected $table = 'flights_classes';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('flight_id', 'class_id');

    public function flight()
    {
        return $this->belongsTo('Flight', 'flight_id');
    }

    public function class()
    {
        return $this->belongsTo('ClassType', 'class_id');
    }

}