<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Message extends Model 
{

    protected $table = 'messages';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('title', 'content', 'from_user_id', 'to_user_id');

    public function fr_user()
    {
        return $this->belongsTo('User', 'from_user_id');
    }

    public function to_user()
    {
        return $this->belongsTo('User', 'to_user_id');
    }

}