<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class OrderVisa extends Model 
{

    protected $table = 'order_visas';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('order_id', 'visa_id', 'number');

    public function order()
    {
        return $this->belongsTo('Order', 'order_id');
    }

    public function visa()
    {
        return $this->belongsTo('Visa', 'visa_id');
    }

}