<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Passenger extends Model 
{

    protected $table = 'passengers';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('order_id', 'first_name', 'last_name', 'title', 'status', 'price', 'ticket', 'ticket_number', 'birth_date', 'birth_place', 'passport_number', 'passport_issuance_date', 'passport_expire_date', 'father_name', 'mother_name', 'age_id');

    public function country()
    {
        return $this->belongsTo('Country', 'nationality_id');
    }

    public function order()
    {
        return $this->belongsTo('Order', 'order_id');
    }

    public function age()
    {
        return $this->belongsTo('Age', 'age_id');
    }

}