<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ReservedSeat extends Model 
{

    protected $table = 'reserved_seats';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'seat_id', 'charter_id', 'class_id', 'price_class_id', 'seats_number', 'total_price');

    public function charter()
    {
        return $this->belongsTo('Charter', 'charter_id');
    }

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function class()
    {
        return $this->belongsTo('ClassType', 'class_id');
    }

    public function price_class()
    {
        return $this->belongsTo('PricingClass', 'price_class_id');
    }

}