<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTravelsTable extends Migration {

	public function up()
	{
		Schema::create('travels', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name_en');
			$table->string('name_ar');
			$table->datetime('from_date');
			$table->datetime('to_date');
			$table->integer('from_country_id');
			$table->integer('to_country_id');
			$table->string('period_en');
			$table->string('period_ar');
			$table->enum('best_offer', array('yes', 'no'));
			$table->string('flight_instructions');
			$table->datetime('going_date');
			$table->integer('going_from_city_id');
			$table->integer('going_to_city_id');
			$table->string('going_flight_number');
			$table->integer('going_aircraft_id');
			$table->integer('going_from_airport_id');
			$table->integer('going_to_airport_id');
			$table->integer('going_airplane_id');
			$table->string('going_from_lounge');
			$table->string('going_to_lounge');
			$table->string('going_departure_time');
			$table->string('going_arrival_time');
			$table->datetime('coming_date');
			$table->integer('coming_from_city_id');
			$table->integer('coming_to_city_id');
			$table->string('coming_flight_number');
			$table->integer('coming_aircraft_id');
			$table->integer('coming_airplane_id');
			$table->integer('coming_from_airport_id');
			$table->integer('coming_to_airport_id');
			$table->string('coming_from_lounge');
			$table->string('coming_to_lounge');
			$table->string('coming_departure_time');
			$table->string('coming_arrival_time');
			$table->enum('electric_port', array('yes', 'no'));
			$table->enum('display', array('yes', 'no'));
			$table->integer('class_id');
			$table->boolean('lock')->default(0);
			$table->integer('adult_id')->nullable();
			$table->integer('adult_number')->nullable();
			$table->integer('children_id')->nullable();
			$table->integer('children_number')->nullable();
			$table->integer('baby_id')->nullable();
			$table->integer('baby_number')->nullable();
			$table->integer('room_type_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('travels');
	}
}