<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVisasTable extends Migration {

	public function up()
	{
		Schema::create('visas', function(Blueprint $table) {
			$table->increments('id');
			$table->softDeletes();
			$table->string('name_en');
			$table->string('name_ar');
			$table->enum('type', array('fast', 'normal'));
			$table->double('price');
			$table->string('papers_en');
			$table->string('papers_ar');
			$table->enum('best_offer', array('yes', 'no'));
			$table->string('description_en');
			$table->string('description_ar');
			$table->timestamps();
			$table->integer('country_id');
			$table->boolean('lock')->default(0);
		});
	}

	public function down()
	{
		Schema::drop('visas');
	}
}