<?php

namespace App;

class Promotion extends Eloquent {

	protected $table = 'promotions';
	public $timestamps = true;
	protected $fillable = array('name', 'shop_id', 'logo', 'ends_at', 'award');

	public function shop()
	{
		return $this->belongsTo('App\Shop');
	}

	public function payment()
	{
		return $this->hasOne('App\Payment');
	}

	public function tickets()
	{
		return $this->hasMany('App\Ticket');
	}

	public function awarded_tickets()
	{
		return $this->hasMany('App\AwardedTicket');
	}

}