<?php

namespace Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Service extends Model 
{

    protected $table = 'services';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('serviceType_id');

    public function beneficiary()
    {
        return $this->hasMany('Beneficiary_service', 'service_id');
    }

    public function service_type()
    {
        return $this->belongsTo('ServiceType');
    }

    public function organization()
    {
        return $this->belongsTo('Organization');
    }

}