<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class House extends Model 
{

    protected $table = 'house';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('country_id', 'name_en', 'name_ar', 'phone', 'address_en', 'address_ar', 'establishment_date', 'description_en', 'description_ar', 'number_of_children', 'average_age', 'activities');

    public function country()
    {
        return $this->belongsTo('Country', 'country_id');
    }

    public function orphans()
    {
        return $this->hasMany('Orphan', 'house_id');
    }

    public function workers()
    {
        return $this->hasMany('HouseWorker', 'house_id');
    }

    public function services()
    {
        return $this->hasMany('HouseService', 'house_id');
    }

}