<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Wishlist extends Model 
{

    protected $table = 'wishlist';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'requirement_id');

    public function requirement()
    {
        return $this->belongsTo('HouseRequirement', 'requirement_id');
    }

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

}