<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProviderRequestTable extends Migration {

	public function up()
	{
		Schema::create('provider_request', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name_en', 255)->nullable();
			$table->string('name_ar', 255)->nullable();
			$table->string('phone', 20)->nullable();
			$table->string('email', 255)->nullable();
			$table->string('address_en', 255)->nullable();
			$table->string('address_ar', 255)->nullable();
			$table->string('type', 255)->nullable();
			$table->text('description_en')->nullable();
			$table->text('description_ar')->nullable();
			$table->text('additional_info_en')->nullable();
			$table->text('additional_info_ar')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('provider_request');
	}
}