<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class HouseService extends Model 
{

    protected $table = 'house_service';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('house_id', 'name_en', 'name_ar', 'description_en', 'description_ar', 'cost_min', 'cost_max', 'is_urgent');

    public function house()
    {
        return $this->belongsTo('House', 'house_id');
    }

}