<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStoreProductTable extends Migration {

	public function up()
	{
		Schema::create('store_product', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('store_id')->nullable();
			$table->string('name_en', 255)->nullable();
			$table->string('name_ar', 255)->nullable();
			$table->decimal('price', 10,2)->nullable();
			$table->string('link', 255)->nullable();
			$table->integer('category_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('store_product');
	}
}