<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('content', function(Blueprint $table) {
			$table->foreign('summary_box')->references('id')->on('point_attributes')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('content', function(Blueprint $table) {
			$table->foreign('special_points')->references('id')->on('point_attributes')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('meals', function(Blueprint $table) {
			$table->foreign('popular_choices')->references('id')->on('food_list')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('meals', function(Blueprint $table) {
			$table->foreign('health_tips')->references('id')->on('point_attributes')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('days', function(Blueprint $table) {
			$table->foreign('meals')->references('id')->on('meals')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('days', function(Blueprint $table) {
			$table->foreign('exercise')->references('id')->on('exercise')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('weeks', function(Blueprint $table) {
			$table->foreign('content')->references('id')->on('content')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('weeks', function(Blueprint $table) {
			$table->foreign('weight')->references('id')->on('weight')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('weeks', function(Blueprint $table) {
			$table->foreign('days')->references('id')->on('days')
						->onDelete('cascade')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('content', function(Blueprint $table) {
			$table->dropForeign('content_summary_box_foreign');
		});
		Schema::table('content', function(Blueprint $table) {
			$table->dropForeign('content_special_points_foreign');
		});
		Schema::table('meals', function(Blueprint $table) {
			$table->dropForeign('meals_popular_choices_foreign');
		});
		Schema::table('meals', function(Blueprint $table) {
			$table->dropForeign('meals_health_tips_foreign');
		});
		Schema::table('days', function(Blueprint $table) {
			$table->dropForeign('days_meals_foreign');
		});
		Schema::table('days', function(Blueprint $table) {
			$table->dropForeign('days_exercise_foreign');
		});
		Schema::table('weeks', function(Blueprint $table) {
			$table->dropForeign('weeks_content_foreign');
		});
		Schema::table('weeks', function(Blueprint $table) {
			$table->dropForeign('weeks_weight_foreign');
		});
		Schema::table('weeks', function(Blueprint $table) {
			$table->dropForeign('weeks_days_foreign');
		});
	}
}