<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateHmoCaseDocumentsTable extends Migration {

	public function up()
	{
		Schema::create('hmo_case_documents', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255);
			$table->string('mime_type', 255);
			$table->string('storage_name', 255);
			$table->integer('document_type_id')->unsigned()->nullable();
			$table->integer('hmo_case_id')->unsigned();
			$table->integer('uploaded_by')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('hmo_case_documents');
	}
}