<?php

namespace App\Models;

class Client extends Eloquent {

	protected $table = 'clients';
	public $timestamps = true;
	protected $fillable = array('name', 'email', 'city_id', 'neighborhood_id', 'password', 'api_token', 'pin_code');
	protected $visible = array('phone');
	protected $hidden = array('api_token', 'pin_code');

	public function comments()
	{
		return $this->hasMany('App\Models\Comment');
	}

	public function orders()
	{
		return $this->hasMany('App\Models\Order');
	}

	public function city()
	{
		return $this->belongsTo('App\Models\City');
	}

	public function neighborhood()
	{
		return $this->belongsTo('App\Models\Neighborhood');
	}

	public function tokens()
	{
		return $this->morphMany('App/Models\Token', 'tokenable');
	}

	public function contacts()
	{
		return $this->hasMany('App/Models\Contact');
	}

	public function notifications()
	{
		return $this->morphMany('App\Models\Notification', 'notificationable');
	}

}