<?php

namespace App\Models;

class Order extends Eloquent {

	protected $table = 'orders';
	public $timestamps = true;
	protected $fillable = array('client_id', 'price', 'delivery_price', 'total_price', 'status', 'commission', 'net', 'address');

	public function meals()
	{
		return $this->belongsToMany('App\Models\Meal');
	}

	public function restaurant()
	{
		return $this->belongsTo('App\Models\Restaurant');
	}

	public function client()
	{
		return $this->belongsTo('App\Models\Client');
	}

}