<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Order extends Eloquent {

	protected $table = 'orders';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function statuses()
	{
		return $this->belongsToMany('App\Models\Status', 'order_statuses', 'order_id', 'status_id')->withTimestamps();
	}

}