<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class PointUser extends Eloquent {

	protected $table = 'point_users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function pointeable()
	{
		return $this->morphTo();
	}

	public function user_id()
	{
		return $this->belongsTo('App\Models\User');
	}

}