<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Review extends Eloquent {

	protected $table = 'reviews';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function user()
	{
		return $this->belongsTo('App\Models\User');
	}

	public function reviewable()
	{
		return $this->morphTo();
	}

}